#include "VOS_API/DX_VOS_SecureStorage.h"

DxSaveSecureItemFunc g_DxSaveItemFunc = DX_NULL;
DxGetSecureItemSizeFunc g_DxGetItemSizeFunc = DX_NULL;
DxLoadSecureItemFunc g_DxLoadItemFunc = DX_NULL;
DxDeleteSecureItemFunc g_DxDeleteItemFunc = DX_NULL;

DxStatus DX_VOS_SaveSecureItem(DxUint32 itemId, const void* data, DxUint32 dataSize)
{
    if (g_DxSaveItemFunc == DX_NULL)
        RETURN_CONST_STATUS(DX_NOT_INITIALIZED);
    return g_DxSaveItemFunc(itemId, data, dataSize);
}

DxStatus DX_VOS_GetSecureItemSize(DxUint32 itemId, DxUint32* dataSize)
{
    if (g_DxGetItemSizeFunc == DX_NULL)
        RETURN_CONST_STATUS(DX_NOT_INITIALIZED);
    return g_DxGetItemSizeFunc(itemId, dataSize);
}

DxStatus DX_VOS_LoadSecureItem(DxUint32 itemId, void* data, DxUint32 dataSize, DxUint32* dataActuallyRead)
{
    if (g_DxLoadItemFunc == DX_NULL)
        RETURN_CONST_STATUS(DX_NOT_INITIALIZED);
    return g_DxLoadItemFunc(itemId, data, dataSize, dataActuallyRead);
}

DxStatus DX_VOS_DeleteSecureItem(DxUint32 itemId)
{
    if (g_DxDeleteItemFunc == DX_NULL)
        RETURN_CONST_STATUS(DX_NOT_INITIALIZED);
    return g_DxDeleteItemFunc(itemId);
}

void DX_VOS_SetSaveSecureItemFunc(DxSaveSecureItemFunc saveSecureItemFunc)
{
    g_DxSaveItemFunc = saveSecureItemFunc;
}

void DX_VOS_SetGetSecureItemSizeFunc(DxGetSecureItemSizeFunc getSecureItemSizeFunc)
{
    g_DxGetItemSizeFunc = getSecureItemSizeFunc;
}

void DX_VOS_SetLoadSecureItemFunc(DxLoadSecureItemFunc loadSecureItemFunc)
{
    g_DxLoadItemFunc = loadSecureItemFunc;
}

void DX_VOS_SetDeleteSecureItemFunc(DxDeleteSecureItemFunc deleteSecureItemFunc)
{
    g_DxDeleteItemFunc = deleteSecureItemFunc;
}
